/*global __ENV : true  */
/*
@endpoint: `GET /groups/:id/issues`
@example_uri: /api/v4/groups/:environment_root_group/issues
@description: [List groups issues](https://docs.gitlab.com/ee/api/issues.html#list-group-issues)
@gpt_data_version: 1
@issue: https://gitlab.com/gitlab-org/gitlab/-/issues/409492
@previous_issues: https://gitlab.com/gitlab-org/gitlab/-/issues/301203
@stressed_components: Postgres, Rails
*/

import http from "k6/http";
import { group } from "k6";
import { Rate } from "k6/metrics";
import { logError, getRpsThresholds, getTtfbThreshold } from "../../lib/gpt_k6_modules.js";

export let thresholds = {
  'rps': { '15.11.0': 0.1, 'latest': 0.15 },
  'ttfb': { '15.11.0': 18000, 'latest': 8500 },
};
export let rpsThresholds = getRpsThresholds(thresholds['rps'])
export let ttfbThreshold = getTtfbThreshold(thresholds['ttfb'])
export let successRate = new Rate("successful_requests")
export let options = {
  thresholds: {
    "successful_requests": [`rate>${__ENV.SUCCESS_RATE_THRESHOLD}`],
    "http_req_waiting": [`p(90)<${ttfbThreshold}`],
    "http_reqs": [`count>=${rpsThresholds['count']}`]
  }
};

export function setup() {
  console.log('')
  console.log(`RPS Threshold: ${rpsThresholds['mean']}/s (${rpsThresholds['count']})`)
  console.log(`TTFB P90 Threshold: ${ttfbThreshold}ms`)
  console.log(`Success Rate Threshold: ${parseFloat(__ENV.SUCCESS_RATE_THRESHOLD) * 100}%`)
}

export default function () {
  group("API - Group Issues List", function () {
    let params = { headers: { "Accept": "application/json", "PRIVATE-TOKEN": `${__ENV.ACCESS_TOKEN}` } };
    let res = http.get(`${__ENV.ENVIRONMENT_URL}/api/v4/groups/${__ENV.ENVIRONMENT_ROOT_GROUP}/issues`, params);
    /20(0|1)/.test(res.status) ? successRate.add(true) : (successRate.add(false), logError(res));
  });
}
