# GitLab Performance Tool

The GitLab Performance Tool (`gpt`) is built and maintained by the [GitLab Delivery: Framework](https://handbook.gitlab.com/handbook/engineering/infrastructure-platforms/gitlab-delivery/framework/) and [Developer Experience: Performance Enablement](https://handbook.gitlab.com/handbook/engineering/infrastructure-platforms/developer-experience/performance-enablement/) teams to provide performance testing of any GitLab instance. The tool has been built upon the industry leading open source tool [k6](https://k6.io) and provides numerous tests that are designed to effectively test the server performance of GitLab.

The tool can be used both manually and automatically, with us doing the latter for automated testing of reference environments via [Pipelines](https://docs.gitlab.com/ee/ci/pipelines/schedules.html).

GPT is used to continuously validate the performance of the GitLab Reference Architectures. Details on how this works can be found in [GitLab documentation](https://docs.gitlab.com/administration/reference_architectures/#validation-and-test-results).

## Documentation

Documentation on how to use the tool can be found in the [`docs/`](docs/README.md) folder:

For those looking to get started quickly, check out our [Quick Start Guide](docs/quick_start.md).

For detailed information about using the GitLab Performance Tool, please refer to:

* [Preparing the Environment](docs/environment_prep.md)
* [Running the Tests](docs/k6.md)

## Test Details

To get more detailed information about the current test list that is run by GPT you can refer to the [Current Test Details wiki page](https://gitlab.com/gitlab-org/quality/performance/wikis/current-test-details).
